// Déclaration des constantes et variables

const int PinPhotoR = 5;
const int PinTone = 8;
const int PinButton = 12;

int State = 0;
int ValButton = 0;
int OldValButton = 0;
int ValCapteur = 0;
int MinPhotoR = 0;
int MaxPhotoR = 0;
String Notes[]={"Do","Re","Mi","Fa","Sol","La","Si"};
const int FreqNotes[] = {262,294,330,350,392,440,494};


// Définition de fonctions

void Etalonnage_PhotoR() {
  char c=' ';
  Serial.println("Etalonnage de la photoresistance:");
  Serial.println("");
  while(c!='C')  
  { 
    int Val=0;      
    Serial.println("Veuillez cacher la photoresistance et saisir 'C' pour continuer.");
    while(!Val)  
      { 
      delay(200); 
      Val=Serial.available();
      ValCapteur = analogRead(PinPhotoR);
      }
    c = Serial.read();
  }
  MinPhotoR=ValCapteur;
  Serial.print("Valeur minimale de la broche de la photoresistance: "); 
  Serial.println(MinPhotoR);
  Serial.println("");
  c=' ';
  while(c!='C')  
    { 
    int Val=0;      
    Serial.print("Veuillez exposer la photoresistance a la lumiere "); 
    Serial.println("et saisir 'C' pour continuer.");
    while(!Val)  
      { 
      delay(200); 
      Val=Serial.available();
      ValCapteur = analogRead(PinPhotoR);
      }
    c = Serial.read();
    } 
  MaxPhotoR=ValCapteur;
  Serial.print("Valeur maximale de la broche de la photoresistance: "); 
  Serial.println(MaxPhotoR);
  Serial.println("");
}


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode (PinButton, INPUT);
  Etalonnage_PhotoR();
  boolean Etalonnage=true;
  while (Etalonnage == true)
  {
    char c=' ';
    while(c!='O' and c!='N')  
      { 
      Serial.println("Voulez vous recommencer l'etalonnage (Saisir 'O' ou 'N')?");  
      Serial.println("");
      int Val=0;      
      while(!Val)  
        { 
        delay(200); 
        Val=Serial.available();
        }
      c = Serial.read();
      }
    if (c=='O') {
      Etalonnage_PhotoR();
      
    }
    else{ 
      Etalonnage=false;
      Serial.println("Appuyez sur le bouton poussoir pour jouer des notes de musique..."); 
    }
  }
}


// Fonction principale en boucle

void loop() {
  ValButton = digitalRead(PinButton);
  delay(10);
  if (ValButton == HIGH and OldValButton == LOW) {
    State = 1 - State;
  }
  OldValButton = ValButton;
  if (State == 1) {
    ValCapteur = analogRead(PinPhotoR);
    for(int i = 0 ; i < 7 ; i++) {
      if (ValCapteur> MinPhotoR+ i*(MaxPhotoR-MinPhotoR)/7 and 
      ValCapteur< MinPhotoR+ (i+1)*(MaxPhotoR-MinPhotoR)/7){
        Serial.println(Notes[i]);
        tone(PinTone,FreqNotes[i]);
        break;
      }
    } 
  }
  else {
    noTone(PinTone);
  }
}
